/*
 * QueryInterface.java
 *
 * Created on February 21, 2003, 5:13 PM
 */

package nom.DannyBrewer.OOoUno;


//----------------------------------------------------------------------
//  UNO imports
//----------------------------------------------------------------------

// base of all interfaces
import com.sun.star.uno.XInterface;

// access the implementations via names
import com.sun.star.comp.servicemanager.ServiceManager;


import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;

import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import com.sun.star.uno.XComponentContext;


//----------------------------------------------------------------------
//  OpenOffice.org imports
//----------------------------------------------------------------------

// staroffice interfaces to provide desktop and componentloader
// and components i.e. spreadsheets, writerdocs etc.
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XComponentLoader;

// additional classes required
import com.sun.star.sheet.*;
import com.sun.star.container.*;
import com.sun.star.table.*;
import com.sun.star.beans.*;
import com.sun.star.style.*;
import com.sun.star.lang.*;
import com.sun.star.drawing.*;
import com.sun.star.text.XText;
import com.sun.star.awt.*;



/**
 *
 * @author  danny brewer
 */
public class QueryInterface {
	private QueryInterface() { }
	
	// The following are syntax sugar for UnoRuntime.queryInterface().
	
	static public XComponentLoader XComponentLoader( Object obj ) {
		return (XComponentLoader) UnoRuntime.queryInterface( XComponentLoader.class, obj );
	}
	
	static public XDrawPage XDrawPage( Object obj ) {
		return (XDrawPage) UnoRuntime.queryInterface( XDrawPage.class, obj );
	}
	
	static public XDrawPagesSupplier XDrawPagesSupplier( Object obj ) {
		return (XDrawPagesSupplier) UnoRuntime.queryInterface( XDrawPagesSupplier.class, obj );
	}
	
	static public XIndexAccess XIndexAccess( Object obj ) {
		return (XIndexAccess) UnoRuntime.queryInterface( XIndexAccess.class, obj );
	}
	
	static public XMultiComponentFactory XMultiComponentFactory( Object obj ) {
		return (XMultiComponentFactory) UnoRuntime.queryInterface( XMultiComponentFactory.class, obj );
	}
	
	static public XMultiServiceFactory XMultiServiceFactory( Object obj ) {
		return (XMultiServiceFactory) UnoRuntime.queryInterface( XMultiServiceFactory.class, obj );
	}
	
	static public XNamed XNamed( Object obj ) {
		return (XNamed) UnoRuntime.queryInterface( XNamed.class, obj );
	}
	
	static public XPropertySet XPropertySet( Object obj ) {
		return (XPropertySet) UnoRuntime.queryInterface( XPropertySet.class, obj );
	}
	
	static public XShape XShape( Object obj ) {
		return (XShape) UnoRuntime.queryInterface( XShape.class, obj );
	}
	
	static public XShapes XShapes( Object obj ) {
		return (XShapes) UnoRuntime.queryInterface( XShapes.class, obj );
	}
	
}


